// Boost.Geometry

// Copyright (c) 2017-2018, Oracle and/or its affiliates.
// Contributed and/or modified by Adam Wulkiewicz, on behalf of Oracle

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)


#ifndef BOOST_GEOMETRY_PROJECTIONS_ESRI_HPP
#define BOOST_GEOMETRY_PROJECTIONS_ESRI_HPP


#include <algorithm>

#include <boost/geometry/srs/projections/code.hpp>


namespace boost { namespace geometry { namespace projections
{


#ifndef DOXYGEN_NO_DETAIL
namespace detail
{

    inline srs::dpar::parameters<> esri_to_parameters(int code)
    {
        using namespace srs::dpar;

        using p = code_parameter;
        using ps = std::array<p, 13>;
        using ce = code_element;

        static constexpr std::array<code_element, 427> arr = {
            ce(37001, ps{p(proj_longlat), p(ellps_wgs66), p(no_defs)}),
            ce(37002, ps{p(proj_longlat), p(a,6378166), p(b,6356784.283607107), p(no_defs)}),
            ce(37003, ps{p(proj_longlat), p(a,6378150), p(b,6356768.337244385), p(no_defs)}),
            ce(37004, ps{p(proj_longlat), p(ellps_fschr60m), p(no_defs)}),
            ce(37005, ps{p(proj_longlat), p(a,6378270), p(b,6356794.343434343), p(no_defs)}),
            ce(37006, ps{p(proj_longlat), p(a,6377295.664), p(b,6356094.667915204), p(no_defs)}),
            ce(37007, ps{p(proj_longlat), p(a,6376896), p(b,6355834.846687363), p(no_defs)}),
            ce(37008, ps{p(proj_longlat), p(r,6370997), p(no_defs)}),
            ce(37201, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37202, ps{p(proj_longlat), p(a,6377276.345), p(b,6356075.41314024), p(no_defs)}),
            ce(37203, ps{p(proj_longlat), p(a,6377301.243), p(b,6356100.230165384), p(no_defs)}),
            ce(37204, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37205, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37206, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(37207, ps{p(proj_longlat), p(ellps_fschr60m), p(no_defs)}),
            ce(37208, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(37211, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(37212, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37213, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37214, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37215, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37216, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37217, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37218, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37219, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37220, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(37221, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37222, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37223, ps{p(proj_longlat), p(a,6378249.2), p(b,6356514.999904194), p(no_defs)}),
            ce(37224, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37226, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37227, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37228, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(37229, ps{p(proj_longlat), p(a,6378270), p(b,6356794.343434343), p(no_defs)}),
            ce(37230, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37231, ps{p(proj_longlat), p(ellps_aust_sa), p(no_defs)}),
            ce(37232, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37233, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37234, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37235, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37237, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37238, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37239, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(37240, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(37241, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37242, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37243, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(37245, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37246, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37247, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37249, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37250, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37251, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37252, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            ce(37253, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37254, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(37255, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(37257, ps{p(proj_longlat), p(ellps_krass), p(no_defs)}),
            ce(37259, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(37260, ps{p(proj_longlat), p(ellps_clrk66), p(no_defs)}),
            //{53001}
            ce(53002, ps{p(proj_eqc), p(lat_ts,60), p(lat_0,0), p(lon_0,0), p(x_0,0), p(y_0,0), p(r,6371000), p(units_m), p(no_defs)}),
            ce(53003, ps{p(proj_mill), p(lat_0,0), p(lon_0,0), p(x_0,0), p(y_0,0), p(r_au), p(r,6371000), p(units_m), p(no_defs)}),
            ce(53004, ps{p(proj_merc), p(lon_0,0), p(k,1), p(x_0,0), p(y_0,0), p(r,6371000), p(units_m), p(no_defs)}),
            ce(53008, ps{p(proj_sinu), p(lon_0,0), p(x_0,0), p(y_0,0), p(r,6371000), p(units_m), p(no_defs)}),
            ce(53009, ps{p(proj_moll), p(lon_0,0), p(x_0,0), p(y_0,0), p(r,6371000), p(units_m), p(no_defs)}),
            ce(53010, ps{p(proj_eck6), p(lon_0,0), p(x_0,0), p(y_0,0), p(r,6371000), p(units_m), p(no_defs)}),
            //{53011}
            ce(53012, ps{p(proj_eck4), p(lon_0,0), p(x_0,0), p(y_0,0), p(r,6371000), p(units_m), p(no_defs)}),
            //{53013}
            //{53014}
            //{53015}
            ce(53016, ps{p(proj_gall), p(lon_0,0), p(x_0,0), p(y_0,0), p(r,6371000), p(units_m), p(no_defs)}),
            //{53017}
            //{53018}
            //{53019}
            ce(53021, ps{p(proj_poly), p(lat_0,0), p(lon_0,0), p(x_0,0), p(y_0,0), p(r,6371000), p(units_m), p(no_defs)}),
            //{53022}
            //{53023}
            ce(53024, ps{p(proj_bonne), p(lon_0,0), p(lat_1,60), p(x_0,0), p(y_0,0), p(r,6371000), p(units_m), p(no_defs)}),
            ce(53025, ps{p(proj_omerc), p(lat_0,40), p(lon_1,0), p(lat_1,0), p(lon_2,0), p(lat_2,0), p(k,1), p(x_0,0), p(y_0,0), p(r,6371000), p(units_m), p(no_defs)}),
            ce(53026, ps{p(proj_stere), p(lat_0,0), p(lon_0,0), p(k,1), p(x_0,0), p(y_0,0), p(r,6371000), p(units_m), p(no_defs)}),
            ce(53027, ps{p(proj_eqdc), p(lat_0,0), p(lon_0,0), p(lat_1,60), p(lat_2,60), p(x_0,0), p(y_0,0), p(r,6371000), p(units_m), p(no_defs)}),
            ce(53028, ps{p(proj_cass), p(lat_0,0), p(lon_0,0), p(x_0,0), p(y_0,0), p(r,6371000), p(units_m), p(no_defs)}),
            ce(53029, ps{p(proj_vandg), p(lon_0,0), p(x_0,0), p(y_0,0), p(r_au), p(r,6371000), p(units_m), p(no_defs)}),
            ce(53030, ps{p(proj_robin), p(lon_0,0), p(x_0,0), p(y_0,0), p(r,6371000), p(units_m), p(no_defs)}),
            ce(53031, ps{p(proj_tpeqd), p(lat_1,0), p(lon_1,0), p(lat_2,60), p(lon_2,60), p(x_0,0), p(y_0,0), p(r,6371000), p(units_m), p(no_defs)}),
            ce(53032, ps{p(proj_aeqd), p(lat_0,0), p(lon_0,0), p(x_0,0), p(y_0,0), p(r,6371000), p(units_m), p(no_defs)}),
            //{54001}
            ce(54002, ps{p(proj_eqc), p(lat_ts,60), p(lat_0,0), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(54003, ps{p(proj_mill), p(lat_0,0), p(lon_0,0), p(x_0,0), p(y_0,0), p(r_au), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(54004, ps{p(proj_merc), p(lon_0,0), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(54008, ps{p(proj_sinu), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(54009, ps{p(proj_moll), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(54010, ps{p(proj_eck6), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            //{54011}
            ce(54012, ps{p(proj_eck4), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            //{54013}
            //{54014}
            //{54015}
            ce(54016, ps{p(proj_gall), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            //{54017}
            //{54018}
            //{54019}
            ce(54021, ps{p(proj_poly), p(lat_0,0), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            //{54022}
            //{54023}
            ce(54024, ps{p(proj_bonne), p(lon_0,0), p(lat_1,60), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(54025, ps{p(proj_omerc), p(lat_0,40), p(lon_1,0), p(lat_1,0), p(lon_2,0), p(lat_2,0), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(54026, ps{p(proj_stere), p(lat_0,0), p(lon_0,0), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(54027, ps{p(proj_eqdc), p(lat_0,0), p(lon_0,0), p(lat_1,60), p(lat_2,60), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(54028, ps{p(proj_cass), p(lat_0,0), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(54029, ps{p(proj_vandg), p(lon_0,0), p(x_0,0), p(y_0,0), p(r_au), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(54030, ps{p(proj_robin), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(54031, ps{p(proj_tpeqd), p(lat_1,0), p(lon_1,0), p(lat_2,60), p(lon_2,60), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(54032, ps{p(proj_aeqd), p(lat_0,0), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(65061, ps{p(proj_poly), p(lat_0,13.47246635277778), p(lon_0,-144.7487507055556), p(x_0,50000.00000000001), p(y_0,50000.00000000001), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(65161, ps{p(proj_poly), p(lat_0,13.47246635277778), p(lon_0,-144.7487507055556), p(x_0,50000), p(y_0,50000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(102001, ps{p(proj_aea), p(lat_1,50), p(lat_2,70), p(lat_0,40), p(lon_0,-96), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(102002, ps{p(proj_lcc), p(lat_1,50), p(lat_2,70), p(lat_0,40), p(lon_0,-96), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(102003, ps{p(proj_aea), p(lat_1,29.5), p(lat_2,45.5), p(lat_0,37.5), p(lon_0,-96), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(102004, ps{p(proj_lcc), p(lat_1,33), p(lat_2,45), p(lat_0,39), p(lon_0,-96), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(102005, ps{p(proj_eqdc), p(lat_0,0), p(lon_0,0), p(lat_1,33), p(lat_2,45), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(102006, ps{p(proj_aea), p(lat_1,55), p(lat_2,65), p(lat_0,50), p(lon_0,-154), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(102007, ps{p(proj_aea), p(lat_1,8), p(lat_2,18), p(lat_0,13), p(lon_0,-157), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(102008, ps{p(proj_aea), p(lat_1,20), p(lat_2,60), p(lat_0,40), p(lon_0,-96), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(102009, ps{p(proj_lcc), p(lat_1,20), p(lat_2,60), p(lat_0,40), p(lon_0,-96), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(102010, ps{p(proj_eqdc), p(lat_0,0), p(lon_0,0), p(lat_1,20), p(lat_2,60), p(x_0,0), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(102011, ps{p(proj_sinu), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(102012, ps{p(proj_lcc), p(lat_1,30), p(lat_2,62), p(lat_0,0), p(lon_0,105), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(102013, ps{p(proj_aea), p(lat_1,43), p(lat_2,62), p(lat_0,30), p(lon_0,10), p(x_0,0), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(102014, ps{p(proj_lcc), p(lat_1,43), p(lat_2,62), p(lat_0,30), p(lon_0,10), p(x_0,0), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(102015, ps{p(proj_lcc), p(lat_1,-5), p(lat_2,-42), p(lat_0,-32), p(lon_0,-60), p(x_0,0), p(y_0,0), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(102016, ps{p(proj_aeqd), p(lat_0,90), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(102017, ps{p(proj_laea), p(lat_0,90), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(102018, ps{p(proj_stere), p(lat_0,90), p(lon_0,0), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(102019, ps{p(proj_aeqd), p(lat_0,-90), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(102020, ps{p(proj_laea), p(lat_0,-90), p(lon_0,0), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(102021, ps{p(proj_stere), p(lat_0,-90), p(lon_0,0), p(k,1), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(102022, ps{p(proj_aea), p(lat_1,20), p(lat_2,-23), p(lat_0,0), p(lon_0,25), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(102023, ps{p(proj_eqdc), p(lat_0,0), p(lon_0,0), p(lat_1,20), p(lat_2,-23), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(102024, ps{p(proj_lcc), p(lat_1,20), p(lat_2,-23), p(lat_0,0), p(lon_0,25), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(102025, ps{p(proj_aea), p(lat_1,15), p(lat_2,65), p(lat_0,30), p(lon_0,95), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(102026, ps{p(proj_eqdc), p(lat_0,0), p(lon_0,0), p(lat_1,15), p(lat_2,65), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(102027, ps{p(proj_lcc), p(lat_1,15), p(lat_2,65), p(lat_0,30), p(lon_0,95), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(102028, ps{p(proj_aea), p(lat_1,7), p(lat_2,-32), p(lat_0,-15), p(lon_0,125), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(102029, ps{p(proj_eqdc), p(lat_0,0), p(lon_0,0), p(lat_1,7), p(lat_2,-32), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(102030, ps{p(proj_lcc), p(lat_1,7), p(lat_2,-32), p(lat_0,-15), p(lon_0,125), p(x_0,0), p(y_0,0), p(ellps_wgs84), p(srs::dpar::datum_wgs84), p(units_m), p(no_defs)}),
            ce(102031, ps{p(proj_eqdc), p(lat_0,0), p(lon_0,0), p(lat_1,43), p(lat_2,62), p(x_0,0), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(102032, ps{p(proj_eqdc), p(lat_0,0), p(lon_0,0), p(lat_1,-5), p(lat_2,-42), p(x_0,0), p(y_0,0), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(102033, ps{p(proj_aea), p(lat_1,-5), p(lat_2,-42), p(lat_0,-32), p(lon_0,-60), p(x_0,0), p(y_0,0), p(ellps_aust_sa), p(units_m), p(no_defs)}),
            ce(102065, ps{p(proj_krovak), p(lat_0,49.5), p(lon_0,24.83333333333333), p(alpha,30.28813975277778), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(102066, ps{p(proj_krovak), p(lat_0,49.5), p(lon_0,42.5), p(alpha,30.28813975277778), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(pm,-17.66666666666667), p(units_m), p(no_defs)}),
            ce(102067, ps{p(proj_krovak), p(lat_0,49.5), p(lon_0,24.83333333333333), p(alpha,30.28813975277778), p(k,0.9999), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(102091, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,9), p(k,0.9996), p(x_0,1500000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(102092, ps{p(proj_tmerc), p(lat_0,0), p(lon_0,15), p(k,0.9996), p(x_0,2520000), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(102101, ps{p(proj_tmerc), p(lat_0,58), p(lon_0,6.05625), p(k,1), p(x_0,0), p(y_0,0), p(a,6377492.018), p(b,6356173.508712696), p(units_m), p(no_defs)}),
            ce(102102, ps{p(proj_tmerc), p(lat_0,58), p(lon_0,8.389583333333333), p(k,1), p(x_0,0), p(y_0,0), p(a,6377492.018), p(b,6356173.508712696), p(units_m), p(no_defs)}),
            ce(102103, ps{p(proj_tmerc), p(lat_0,58), p(lon_0,10.72291666666667), p(k,1), p(x_0,0), p(y_0,0), p(a,6377492.018), p(b,6356173.508712696), p(units_m), p(no_defs)}),
            ce(102104, ps{p(proj_tmerc), p(lat_0,58), p(lon_0,13.22291666666667), p(k,1), p(x_0,0), p(y_0,0), p(a,6377492.018), p(b,6356173.508712696), p(units_m), p(no_defs)}),
            ce(102105, ps{p(proj_tmerc), p(lat_0,58), p(lon_0,16.88958333333333), p(k,1), p(x_0,0), p(y_0,0), p(a,6377492.018), p(b,6356173.508712696), p(units_m), p(no_defs)}),
            ce(102106, ps{p(proj_tmerc), p(lat_0,58), p(lon_0,20.88958333333333), p(k,1), p(x_0,0), p(y_0,0), p(a,6377492.018), p(b,6356173.508712696), p(units_m), p(no_defs)}),
            ce(102107, ps{p(proj_tmerc), p(lat_0,58), p(lon_0,24.88958333333333), p(k,1), p(x_0,0), p(y_0,0), p(a,6377492.018), p(b,6356173.508712696), p(units_m), p(no_defs)}),
            ce(102108, ps{p(proj_tmerc), p(lat_0,58), p(lon_0,29.05625), p(k,1), p(x_0,0), p(y_0,0), p(a,6377492.018), p(b,6356173.508712696), p(units_m), p(no_defs)}),
            ce(102110, ps{p(proj_lcc), p(lat_1,44), p(lat_2,49), p(lat_0,46.5), p(lon_0,3), p(x_0,700000), p(y_0,6600000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102114, ps{p(proj_utm), p(zone,4), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(102115, ps{p(proj_utm), p(zone,5), p(ellps_clrk66), p(units_m), p(no_defs)}),
            ce(102120, ps{p(proj_omerc), p(lat_0,45.30916666666666), p(lonc,-86), p(alpha,337.255555555556), p(k,0.9996), p(x_0,2546731.495961392), p(y_0,-4354009.816002033), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102121, ps{p(proj_omerc), p(lat_0,45.30916666666666), p(lonc,-86), p(alpha,337.255555555556), p(k,0.9996), p(x_0,2546731.495961392), p(y_0,-4354009.816002033), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102122, ps{p(proj_omerc), p(lat_0,45.30916666666666), p(lonc,-86), p(alpha,337.255555555556), p(k,0.9996), p(x_0,2546731.496), p(y_0,-4354009.816), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(units_m), p(no_defs)}),
            ce(102123, ps{p(proj_omerc), p(lat_0,45.30916666666666), p(lonc,-86), p(alpha,337.255555555556), p(k,0.9996), p(x_0,2546731.496), p(y_0,-4354009.816), p(ellps_grs80), p(srs::dpar::datum_nad83), p(units_m), p(no_defs)}),
            ce(102132, ps{p(proj_utm), p(zone,32), p(a,6377492.018), p(b,6356173.508712696), p(units_m), p(no_defs)}),
            ce(102133, ps{p(proj_utm), p(zone,33), p(a,6377492.018), p(b,6356173.508712696), p(units_m), p(no_defs)}),
            ce(102134, ps{p(proj_utm), p(zone,34), p(a,6377492.018), p(b,6356173.508712696), p(units_m), p(no_defs)}),
            ce(102135, ps{p(proj_utm), p(zone,35), p(a,6377492.018), p(b,6356173.508712696), p(units_m), p(no_defs)}),
            ce(102140, ps{p(proj_tmerc), p(lat_0,22.31213333333334), p(lon_0,114.1785555555556), p(k,1), p(x_0,836694.05), p(y_0,819069.8), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(102141, ps{p(proj_utm), p(zone,49), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(102142, ps{p(proj_utm), p(zone,50), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(102151, ps{p(proj_utm), p(zone,51), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(102152, ps{p(proj_utm), p(zone,52), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(102153, ps{p(proj_utm), p(zone,53), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(102154, ps{p(proj_utm), p(zone,54), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(102155, ps{p(proj_utm), p(zone,55), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(102156, ps{p(proj_utm), p(zone,56), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(102160, ps{p(proj_tmerc), p(lat_0,39.66666666666666), p(lon_0,-8.131906111111112), p(k,1), p(x_0,200180.598), p(y_0,299913.01), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(102161, ps{p(proj_tmerc), p(lat_0,39.66666666666666), p(lon_0,-8.131906111111112), p(k,1), p(x_0,180.598), p(y_0,-86.98999999999999), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(102162, ps{p(proj_utm), p(zone,26), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(102163, ps{p(proj_bonne), p(lon_0,-8.131906111111112), p(lat_1,39.66666666666666), p(x_0,0), p(y_0,0), p(ellps_bessel), p(units_m), p(no_defs)}),
            ce(102164, ps{p(proj_tmerc), p(lat_0,39.66666666666666), p(lon_0,-8.131906111111112), p(k,1), p(x_0,200000), p(y_0,300000), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(102165, ps{p(proj_tmerc), p(lat_0,39.66666666666666), p(lon_0,-8.131906111111112), p(k,1), p(x_0,0), p(y_0,0), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(102166, ps{p(proj_utm), p(zone,25), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(102167, ps{p(proj_utm), p(zone,28), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(102168, ps{p(proj_utm), p(zone,26), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(102169, ps{p(proj_utm), p(zone,28), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(102191, ps{p(proj_lcc), p(lat_1,33.3), p(lat_0,33.3), p(lon_0,-5.4), p(k_0,0.999625769), p(x_0,500000), p(y_0,300000), p(a,6378249.2), p(b,6356514.999904194), p(units_m), p(no_defs)}),
            ce(102192, ps{p(proj_lcc), p(lat_1,29.7), p(lat_0,29.7), p(lon_0,-5.4), p(k_0,0.9996155960000001), p(x_0,500000), p(y_0,300000), p(a,6378249.2), p(b,6356514.999904194), p(units_m), p(no_defs)}),
            ce(102193, ps{p(proj_lcc), p(lat_1,26.1), p(lat_0,26.1), p(lon_0,-5.4), p(k_0,0.9996), p(x_0,1200000), p(y_0,400000), p(a,6378249.2), p(b,6356514.999904194), p(units_m), p(no_defs)}),
            ce(102229, ps{p(proj_tmerc), p(lat_0,30.5), p(lon_0,-85.83333333333333), p(k,0.99996), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102230, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-87.5), p(k,0.9999333333333333), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102241, ps{p(proj_lcc), p(lat_1,40), p(lat_2,41.66666666666666), p(lat_0,39.33333333333334), p(lon_0,-122), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102242, ps{p(proj_lcc), p(lat_1,38.33333333333334), p(lat_2,39.83333333333334), p(lat_0,37.66666666666666), p(lon_0,-122), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102243, ps{p(proj_lcc), p(lat_1,37.06666666666667), p(lat_2,38.43333333333333), p(lat_0,36.5), p(lon_0,-120.5), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102244, ps{p(proj_lcc), p(lat_1,36), p(lat_2,37.25), p(lat_0,35.33333333333334), p(lon_0,-119), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102245, ps{p(proj_lcc), p(lat_1,34.03333333333333), p(lat_2,35.46666666666667), p(lat_0,33.5), p(lon_0,-118), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102246, ps{p(proj_lcc), p(lat_1,32.78333333333333), p(lat_2,33.88333333333333), p(lat_0,32.16666666666666), p(lon_0,-116.25), p(x_0,2000000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102248, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-110.1666666666667), p(k,0.9999), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102249, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-111.9166666666667), p(k,0.9999), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102250, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-113.75), p(k,0.9999333333333333), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102251, ps{p(proj_lcc), p(lat_1,34.93333333333333), p(lat_2,36.23333333333333), p(lat_0,34.33333333333334), p(lon_0,-92), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102252, ps{p(proj_lcc), p(lat_1,33.3), p(lat_2,34.76666666666667), p(lat_0,32.66666666666666), p(lon_0,-92), p(x_0,400000), p(y_0,400000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102253, ps{p(proj_lcc), p(lat_1,39.71666666666667), p(lat_2,40.78333333333333), p(lat_0,39.33333333333334), p(lon_0,-105.5), p(x_0,914401.8289), p(y_0,304800.6096), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102254, ps{p(proj_lcc), p(lat_1,38.45), p(lat_2,39.75), p(lat_0,37.83333333333334), p(lon_0,-105.5), p(x_0,914401.8289), p(y_0,304800.6096), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102255, ps{p(proj_lcc), p(lat_1,37.23333333333333), p(lat_2,38.43333333333333), p(lat_0,36.66666666666666), p(lon_0,-105.5), p(x_0,914401.8289), p(y_0,304800.6096), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102256, ps{p(proj_lcc), p(lat_1,41.2), p(lat_2,41.86666666666667), p(lat_0,40.83333333333334), p(lon_0,-72.75), p(x_0,304800.6096), p(y_0,152400.3048), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102257, ps{p(proj_tmerc), p(lat_0,38), p(lon_0,-75.41666666666667), p(k,0.999995), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102258, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-81), p(k,0.9999411764705882), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102259, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-82), p(k,0.9999411764705882), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102260, ps{p(proj_lcc), p(lat_1,29.58333333333333), p(lat_2,30.75), p(lat_0,29), p(lon_0,-84.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102261, ps{p(proj_tmerc), p(lat_0,18.83333333333333), p(lon_0,-155.5), p(k,0.9999666666666667), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102262, ps{p(proj_tmerc), p(lat_0,20.33333333333333), p(lon_0,-156.6666666666667), p(k,0.9999666666666667), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102263, ps{p(proj_tmerc), p(lat_0,21.16666666666667), p(lon_0,-158), p(k,0.99999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102264, ps{p(proj_tmerc), p(lat_0,21.83333333333333), p(lon_0,-159.5), p(k,0.99999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102265, ps{p(proj_tmerc), p(lat_0,21.66666666666667), p(lon_0,-160.1666666666667), p(k,1), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102266, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-82.16666666666667), p(k,0.9999), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102267, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-84.16666666666667), p(k,0.9999), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102268, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-112.1666666666667), p(k,0.9999473684210526), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102269, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-114), p(k,0.9999473684210526), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102270, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-115.75), p(k,0.9999333333333333), p(x_0,800000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102271, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-88.33333333333333), p(k,0.9999749999999999), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102272, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-90.16666666666667), p(k,0.9999411764705882), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102273, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-85.66666666666667), p(k,0.9999666666666667), p(x_0,100000), p(y_0,250000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102274, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-87.08333333333333), p(k,0.9999666666666667), p(x_0,900000), p(y_0,250000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102277, ps{p(proj_lcc), p(lat_1,38.71666666666667), p(lat_2,39.78333333333333), p(lat_0,38.33333333333334), p(lon_0,-98), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102278, ps{p(proj_lcc), p(lat_1,37.26666666666667), p(lat_2,38.56666666666667), p(lat_0,36.66666666666666), p(lon_0,-98.5), p(x_0,400000), p(y_0,400000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102279, ps{p(proj_lcc), p(lat_1,37.96666666666667), p(lat_2,38.96666666666667), p(lat_0,37.5), p(lon_0,-84.25), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102280, ps{p(proj_lcc), p(lat_1,36.73333333333333), p(lat_2,37.93333333333333), p(lat_0,36.33333333333334), p(lon_0,-85.75), p(x_0,500000), p(y_0,500000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102281, ps{p(proj_lcc), p(lat_1,31.16666666666667), p(lat_2,32.66666666666666), p(lat_0,30.5), p(lon_0,-92.5), p(x_0,1000000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102282, ps{p(proj_lcc), p(lat_1,29.3), p(lat_2,30.7), p(lat_0,28.5), p(lon_0,-91.33333333333333), p(x_0,1000000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102283, ps{p(proj_tmerc), p(lat_0,43.66666666666666), p(lon_0,-68.5), p(k,0.9999), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102284, ps{p(proj_tmerc), p(lat_0,42.83333333333334), p(lon_0,-70.16666666666667), p(k,0.9999666666666667), p(x_0,900000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102285, ps{p(proj_lcc), p(lat_1,38.3), p(lat_2,39.45), p(lat_0,37.66666666666666), p(lon_0,-77), p(x_0,400000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102286, ps{p(proj_lcc), p(lat_1,41.71666666666667), p(lat_2,42.68333333333333), p(lat_0,41), p(lon_0,-71.5), p(x_0,200000), p(y_0,750000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102287, ps{p(proj_lcc), p(lat_1,41.28333333333333), p(lat_2,41.48333333333333), p(lat_0,41), p(lon_0,-70.5), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102288, ps{p(proj_lcc), p(lat_1,45.48333333333333), p(lat_2,47.08333333333334), p(lat_0,44.78333333333333), p(lon_0,-87), p(x_0,8000000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102289, ps{p(proj_lcc), p(lat_1,44.18333333333333), p(lat_2,45.7), p(lat_0,43.31666666666667), p(lon_0,-84.36666666666666), p(x_0,6000000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102290, ps{p(proj_lcc), p(lat_1,42.1), p(lat_2,43.66666666666666), p(lat_0,41.5), p(lon_0,-84.36666666666666), p(x_0,4000000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102291, ps{p(proj_lcc), p(lat_1,47.03333333333333), p(lat_2,48.63333333333333), p(lat_0,46.5), p(lon_0,-93.09999999999999), p(x_0,800000), p(y_0,100000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102292, ps{p(proj_lcc), p(lat_1,45.61666666666667), p(lat_2,47.05), p(lat_0,45), p(lon_0,-94.25), p(x_0,800000), p(y_0,100000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102293, ps{p(proj_lcc), p(lat_1,43.78333333333333), p(lat_2,45.21666666666667), p(lat_0,43), p(lon_0,-94), p(x_0,800000), p(y_0,100000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102294, ps{p(proj_tmerc), p(lat_0,29.5), p(lon_0,-88.83333333333333), p(k,0.99995), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102295, ps{p(proj_tmerc), p(lat_0,29.5), p(lon_0,-90.33333333333333), p(k,0.99995), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102296, ps{p(proj_tmerc), p(lat_0,35.83333333333334), p(lon_0,-90.5), p(k,0.9999333333333333), p(x_0,250000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102297, ps{p(proj_tmerc), p(lat_0,35.83333333333334), p(lon_0,-92.5), p(k,0.9999333333333333), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102298, ps{p(proj_tmerc), p(lat_0,36.16666666666666), p(lon_0,-94.5), p(k,0.9999411764705882), p(x_0,850000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102300, ps{p(proj_lcc), p(lat_1,45), p(lat_2,49), p(lat_0,44.25), p(lon_0,-109.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102304, ps{p(proj_lcc), p(lat_1,40), p(lat_2,43), p(lat_0,39.83333333333334), p(lon_0,-100), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102307, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-115.5833333333333), p(k,0.9999), p(x_0,200000), p(y_0,8000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102308, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-116.6666666666667), p(k,0.9999), p(x_0,500000), p(y_0,6000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102309, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-118.5833333333333), p(k,0.9999), p(x_0,800000), p(y_0,4000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102310, ps{p(proj_tmerc), p(lat_0,42.5), p(lon_0,-71.66666666666667), p(k,0.9999666666666667), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102311, ps{p(proj_tmerc), p(lat_0,38.83333333333334), p(lon_0,-74.5), p(k,0.9999), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102312, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-104.3333333333333), p(k,0.9999090909090909), p(x_0,165000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102313, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-106.25), p(k,0.9999), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102314, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-107.8333333333333), p(k,0.9999166666666667), p(x_0,830000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102315, ps{p(proj_tmerc), p(lat_0,38.83333333333334), p(lon_0,-74.5), p(k,0.9999), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102316, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-76.58333333333333), p(k,0.9999375), p(x_0,250000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102317, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-78.58333333333333), p(k,0.9999375), p(x_0,350000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102318, ps{p(proj_lcc), p(lat_1,40.66666666666666), p(lat_2,41.03333333333333), p(lat_0,40.16666666666666), p(lon_0,-74), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102320, ps{p(proj_lcc), p(lat_1,47.43333333333333), p(lat_2,48.73333333333333), p(lat_0,47), p(lon_0,-100.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102321, ps{p(proj_lcc), p(lat_1,46.18333333333333), p(lat_2,47.48333333333333), p(lat_0,45.66666666666666), p(lon_0,-100.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102322, ps{p(proj_lcc), p(lat_1,40.43333333333333), p(lat_2,41.7), p(lat_0,39.66666666666666), p(lon_0,-82.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102323, ps{p(proj_lcc), p(lat_1,38.73333333333333), p(lat_2,40.03333333333333), p(lat_0,38), p(lon_0,-82.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102324, ps{p(proj_lcc), p(lat_1,35.56666666666667), p(lat_2,36.76666666666667), p(lat_0,35), p(lon_0,-98), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102325, ps{p(proj_lcc), p(lat_1,33.93333333333333), p(lat_2,35.23333333333333), p(lat_0,33.33333333333334), p(lon_0,-98), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102326, ps{p(proj_lcc), p(lat_1,44.33333333333334), p(lat_2,46), p(lat_0,43.66666666666666), p(lon_0,-120.5), p(x_0,2500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102327, ps{p(proj_lcc), p(lat_1,42.33333333333334), p(lat_2,44), p(lat_0,41.66666666666666), p(lon_0,-120.5), p(x_0,1500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102330, ps{p(proj_tmerc), p(lat_0,41.08333333333334), p(lon_0,-71.5), p(k,0.99999375), p(x_0,100000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102334, ps{p(proj_lcc), p(lat_1,44.41666666666666), p(lat_2,45.68333333333333), p(lat_0,43.83333333333334), p(lon_0,-100), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102335, ps{p(proj_lcc), p(lat_1,42.83333333333334), p(lat_2,44.4), p(lat_0,42.33333333333334), p(lon_0,-100.3333333333333), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102336, ps{p(proj_lcc), p(lat_1,35.25), p(lat_2,36.41666666666666), p(lat_0,34.33333333333334), p(lon_0,-86), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102337, ps{p(proj_lcc), p(lat_1,34.65), p(lat_2,36.18333333333333), p(lat_0,34), p(lon_0,-101.5), p(x_0,200000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102338, ps{p(proj_lcc), p(lat_1,32.13333333333333), p(lat_2,33.96666666666667), p(lat_0,31.66666666666667), p(lon_0,-98.5), p(x_0,600000), p(y_0,2000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102339, ps{p(proj_lcc), p(lat_1,30.11666666666667), p(lat_2,31.88333333333333), p(lat_0,29.66666666666667), p(lon_0,-100.3333333333333), p(x_0,700000), p(y_0,3000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102340, ps{p(proj_lcc), p(lat_1,28.38333333333333), p(lat_2,30.28333333333334), p(lat_0,27.83333333333333), p(lon_0,-99), p(x_0,600000), p(y_0,4000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102341, ps{p(proj_lcc), p(lat_1,26.16666666666667), p(lat_2,27.83333333333333), p(lat_0,25.66666666666667), p(lon_0,-98.5), p(x_0,300000), p(y_0,5000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102342, ps{p(proj_lcc), p(lat_1,40.71666666666667), p(lat_2,41.78333333333333), p(lat_0,40.33333333333334), p(lon_0,-111.5), p(x_0,500000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102343, ps{p(proj_lcc), p(lat_1,39.01666666666667), p(lat_2,40.65), p(lat_0,38.33333333333334), p(lon_0,-111.5), p(x_0,500000), p(y_0,2000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102344, ps{p(proj_lcc), p(lat_1,37.21666666666667), p(lat_2,38.35), p(lat_0,36.66666666666666), p(lon_0,-111.5), p(x_0,500000), p(y_0,3000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102345, ps{p(proj_tmerc), p(lat_0,42.5), p(lon_0,-72.5), p(k,0.9999642857142857), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102346, ps{p(proj_lcc), p(lat_1,38.03333333333333), p(lat_2,39.2), p(lat_0,37.66666666666666), p(lon_0,-78.5), p(x_0,3500000), p(y_0,2000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102347, ps{p(proj_lcc), p(lat_1,36.76666666666667), p(lat_2,37.96666666666667), p(lat_0,36.33333333333334), p(lon_0,-78.5), p(x_0,3500000), p(y_0,1000000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102348, ps{p(proj_lcc), p(lat_1,47.5), p(lat_2,48.73333333333333), p(lat_0,47), p(lon_0,-120.8333333333333), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102349, ps{p(proj_lcc), p(lat_1,45.83333333333334), p(lat_2,47.33333333333334), p(lat_0,45.33333333333334), p(lon_0,-120.5), p(x_0,500000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102350, ps{p(proj_lcc), p(lat_1,39), p(lat_2,40.25), p(lat_0,38.5), p(lon_0,-79.5), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102351, ps{p(proj_lcc), p(lat_1,37.48333333333333), p(lat_2,38.88333333333333), p(lat_0,37), p(lon_0,-81), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102352, ps{p(proj_lcc), p(lat_1,45.56666666666667), p(lat_2,46.76666666666667), p(lat_0,45.16666666666666), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102353, ps{p(proj_lcc), p(lat_1,44.25), p(lat_2,45.5), p(lat_0,43.83333333333334), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102354, ps{p(proj_lcc), p(lat_1,42.73333333333333), p(lat_2,44.06666666666667), p(lat_0,42), p(lon_0,-90), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102355, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-105.1666666666667), p(k,0.9999375), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102356, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-107.3333333333333), p(k,0.9999375), p(x_0,400000), p(y_0,100000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102357, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-108.75), p(k,0.9999375), p(x_0,600000), p(y_0,0), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102358, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-110.0833333333333), p(k,0.9999375), p(x_0,800000), p(y_0,100000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102361, ps{p(proj_lcc), p(lat_1,18.03333333333334), p(lat_2,18.43333333333333), p(lat_0,17.83333333333333), p(lon_0,-66.43333333333334), p(x_0,200000), p(y_0,200000), p(ellps_grs80), p(units_m), p(no_defs)}),
            ce(102491, ps{p(proj_lcc), p(lat_1,36), p(lat_0,36), p(lon_0,2.7), p(k_0,0.999625544), p(x_0,500000), p(y_0,300000), p(a,6378249.2), p(b,6356514.999904194), p(units_m), p(no_defs)}),
            ce(102492, ps{p(proj_lcc), p(lat_1,33.3), p(lat_0,33.3), p(lon_0,2.7), p(k_0,0.999625769), p(x_0,500000), p(y_0,300000), p(a,6378249.2), p(b,6356514.999904194), p(units_m), p(no_defs)}),
            ce(102581, ps{p(proj_lcc), p(lat_1,49.5), p(lat_0,49.5), p(lon_0,2.337229166666667), p(k_0,0.999877341), p(x_0,600000), p(y_0,1200000), p(a,6378249.2), p(b,6356514.999904194), p(units_m), p(no_defs)}),
            ce(102582, ps{p(proj_lcc), p(lat_1,46.8), p(lat_0,46.8), p(lon_0,2.337229166666667), p(k_0,0.99987742), p(x_0,600000), p(y_0,2200000), p(a,6378249.2), p(b,6356514.999904194), p(units_m), p(no_defs)}),
            ce(102583, ps{p(proj_lcc), p(lat_1,44.1), p(lat_0,44.1), p(lon_0,2.337229166666667), p(k_0,0.999877499), p(x_0,600000), p(y_0,3200000), p(a,6378249.2), p(b,6356514.999904194), p(units_m), p(no_defs)}),
            ce(102584, ps{p(proj_lcc), p(lat_1,42.165), p(lat_0,42.165), p(lon_0,2.337229166666667), p(k_0,0.99994471), p(x_0,234.358), p(y_0,4185861.369), p(a,6378249.2), p(b,6356514.999904194), p(units_m), p(no_defs)}),
            ce(102591, ps{p(proj_lcc), p(lat_1,36), p(lat_0,36), p(lon_0,2.7), p(k_0,0.999625544), p(x_0,500135), p(y_0,300090), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(102592, ps{p(proj_lcc), p(lat_1,33.3), p(lat_0,33.3), p(lon_0,2.7), p(k_0,0.999625769), p(x_0,500135), p(y_0,300090), p(ellps_clrk80), p(units_m), p(no_defs)}),
            ce(102629, ps{p(proj_tmerc), p(lat_0,30.5), p(lon_0,-85.83333333333333), p(k,0.99996), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102630, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-87.5), p(k,0.9999333333333333), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102631, ps{p(proj_omerc), p(lat_0,57), p(lonc,-133.6666666666667), p(alpha,-36.86989764583333), p(k,0.9999), p(x_0,4999999.999999999), p(y_0,-4999999.999999999), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102632, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-142), p(k,0.9999), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102633, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-146), p(k,0.9999), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102634, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-150), p(k,0.9999), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102635, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-154), p(k,0.9999), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102636, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-158), p(k,0.9999), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102637, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-162), p(k,0.9999), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102638, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-166), p(k,0.9999), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102639, ps{p(proj_tmerc), p(lat_0,54), p(lon_0,-170), p(k,0.9999), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102640, ps{p(proj_lcc), p(lat_1,51.83333333333334), p(lat_2,53.83333333333334), p(lat_0,51), p(lon_0,-176), p(x_0,1000000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102641, ps{p(proj_lcc), p(lat_1,40), p(lat_2,41.66666666666666), p(lat_0,39.33333333333334), p(lon_0,-122), p(x_0,2000000), p(y_0,500000.0000000002), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102642, ps{p(proj_lcc), p(lat_1,38.33333333333334), p(lat_2,39.83333333333334), p(lat_0,37.66666666666666), p(lon_0,-122), p(x_0,2000000), p(y_0,500000.0000000002), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102643, ps{p(proj_lcc), p(lat_1,37.06666666666667), p(lat_2,38.43333333333333), p(lat_0,36.5), p(lon_0,-120.5), p(x_0,2000000), p(y_0,500000.0000000002), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102644, ps{p(proj_lcc), p(lat_1,36), p(lat_2,37.25), p(lat_0,35.33333333333334), p(lon_0,-119), p(x_0,2000000), p(y_0,500000.0000000002), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102645, ps{p(proj_lcc), p(lat_1,34.03333333333333), p(lat_2,35.46666666666667), p(lat_0,33.5), p(lon_0,-118), p(x_0,2000000), p(y_0,500000.0000000002), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102646, ps{p(proj_lcc), p(lat_1,32.78333333333333), p(lat_2,33.88333333333333), p(lat_0,32.16666666666666), p(lon_0,-116.25), p(x_0,2000000), p(y_0,500000.0000000002), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102648, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-110.1666666666667), p(k,0.9999), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102649, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-111.9166666666667), p(k,0.9999), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102650, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-113.75), p(k,0.9999333333333333), p(x_0,213360), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102651, ps{p(proj_lcc), p(lat_1,34.93333333333333), p(lat_2,36.23333333333333), p(lat_0,34.33333333333334), p(lon_0,-92), p(x_0,399999.9999999999), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102652, ps{p(proj_lcc), p(lat_1,33.3), p(lat_2,34.76666666666667), p(lat_0,32.66666666666666), p(lon_0,-92), p(x_0,399999.9999999999), p(y_0,399999.9999999999), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102653, ps{p(proj_lcc), p(lat_1,39.71666666666667), p(lat_2,40.78333333333333), p(lat_0,39.33333333333334), p(lon_0,-105.5), p(x_0,914401.8289), p(y_0,304800.6096), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102654, ps{p(proj_lcc), p(lat_1,38.45), p(lat_2,39.75), p(lat_0,37.83333333333334), p(lon_0,-105.5), p(x_0,914401.8289), p(y_0,304800.6096), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102655, ps{p(proj_lcc), p(lat_1,37.23333333333333), p(lat_2,38.43333333333333), p(lat_0,36.66666666666666), p(lon_0,-105.5), p(x_0,914401.8289), p(y_0,304800.6096), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102656, ps{p(proj_lcc), p(lat_1,41.2), p(lat_2,41.86666666666667), p(lat_0,40.83333333333334), p(lon_0,-72.75), p(x_0,304800.6096), p(y_0,152400.3048), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102657, ps{p(proj_tmerc), p(lat_0,38), p(lon_0,-75.41666666666667), p(k,0.999995), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102658, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-81), p(k,0.9999411764705882), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102659, ps{p(proj_tmerc), p(lat_0,24.33333333333333), p(lon_0,-82), p(k,0.9999411764705882), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102660, ps{p(proj_lcc), p(lat_1,29.58333333333333), p(lat_2,30.75), p(lat_0,29), p(lon_0,-84.5), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102661, ps{p(proj_tmerc), p(lat_0,18.83333333333333), p(lon_0,-155.5), p(k,0.9999666666666667), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102662, ps{p(proj_tmerc), p(lat_0,20.33333333333333), p(lon_0,-156.6666666666667), p(k,0.9999666666666667), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102663, ps{p(proj_tmerc), p(lat_0,21.16666666666667), p(lon_0,-158), p(k,0.99999), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102664, ps{p(proj_tmerc), p(lat_0,21.83333333333333), p(lon_0,-159.5), p(k,0.99999), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102665, ps{p(proj_tmerc), p(lat_0,21.66666666666667), p(lon_0,-160.1666666666667), p(k,1), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102666, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-82.16666666666667), p(k,0.9999), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102667, ps{p(proj_tmerc), p(lat_0,30), p(lon_0,-84.16666666666667), p(k,0.9999), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102668, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-112.1666666666667), p(k,0.9999473684210526), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102669, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-114), p(k,0.9999473684210526), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102670, ps{p(proj_tmerc), p(lat_0,41.66666666666666), p(lon_0,-115.75), p(k,0.9999333333333333), p(x_0,799999.9999999999), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102671, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-88.33333333333333), p(k,0.9999749999999999), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102672, ps{p(proj_tmerc), p(lat_0,36.66666666666666), p(lon_0,-90.16666666666667), p(k,0.9999411764705882), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102673, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-85.66666666666667), p(k,0.9999666666666667), p(x_0,100000), p(y_0,250000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102674, ps{p(proj_tmerc), p(lat_0,37.5), p(lon_0,-87.08333333333333), p(k,0.9999666666666667), p(x_0,900000.0000000001), p(y_0,250000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102675, ps{p(proj_lcc), p(lat_1,42.06666666666667), p(lat_2,43.26666666666667), p(lat_0,41.5), p(lon_0,-93.5), p(x_0,1500000), p(y_0,1000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102676, ps{p(proj_lcc), p(lat_1,40.61666666666667), p(lat_2,41.78333333333333), p(lat_0,40), p(lon_0,-93.5), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102677, ps{p(proj_lcc), p(lat_1,38.71666666666667), p(lat_2,39.78333333333333), p(lat_0,38.33333333333334), p(lon_0,-98), p(x_0,399999.9999999999), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102678, ps{p(proj_lcc), p(lat_1,37.26666666666667), p(lat_2,38.56666666666667), p(lat_0,36.66666666666666), p(lon_0,-98.5), p(x_0,399999.9999999999), p(y_0,399999.9999999999), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102679, ps{p(proj_lcc), p(lat_1,37.96666666666667), p(lat_2,38.96666666666667), p(lat_0,37.5), p(lon_0,-84.25), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102680, ps{p(proj_lcc), p(lat_1,36.73333333333333), p(lat_2,37.93333333333333), p(lat_0,36.33333333333334), p(lon_0,-85.75), p(x_0,500000.0000000002), p(y_0,500000.0000000002), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102681, ps{p(proj_lcc), p(lat_1,31.16666666666667), p(lat_2,32.66666666666666), p(lat_0,30.5), p(lon_0,-92.5), p(x_0,1000000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102682, ps{p(proj_lcc), p(lat_1,29.3), p(lat_2,30.7), p(lat_0,28.5), p(lon_0,-91.33333333333333), p(x_0,1000000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102683, ps{p(proj_tmerc), p(lat_0,43.66666666666666), p(lon_0,-68.5), p(k,0.9999), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102684, ps{p(proj_tmerc), p(lat_0,42.83333333333334), p(lon_0,-70.16666666666667), p(k,0.9999666666666667), p(x_0,900000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102685, ps{p(proj_lcc), p(lat_1,38.3), p(lat_2,39.45), p(lat_0,37.66666666666666), p(lon_0,-77), p(x_0,399999.9999999999), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102686, ps{p(proj_lcc), p(lat_1,41.71666666666667), p(lat_2,42.68333333333333), p(lat_0,41), p(lon_0,-71.5), p(x_0,200000), p(y_0,750000.0000000001), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102687, ps{p(proj_lcc), p(lat_1,41.28333333333333), p(lat_2,41.48333333333333), p(lat_0,41), p(lon_0,-70.5), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102688, ps{p(proj_lcc), p(lat_1,45.48333333333333), p(lat_2,47.08333333333334), p(lat_0,44.78333333333333), p(lon_0,-87), p(x_0,7999999.999999999), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102689, ps{p(proj_lcc), p(lat_1,44.18333333333333), p(lat_2,45.7), p(lat_0,43.31666666666667), p(lon_0,-84.36666666666666), p(x_0,6000000.000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102690, ps{p(proj_lcc), p(lat_1,42.1), p(lat_2,43.66666666666666), p(lat_0,41.5), p(lon_0,-84.36666666666666), p(x_0,4000000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102691, ps{p(proj_lcc), p(lat_1,47.03333333333333), p(lat_2,48.63333333333333), p(lat_0,46.5), p(lon_0,-93.09999999999999), p(x_0,799999.9999999999), p(y_0,100000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102692, ps{p(proj_lcc), p(lat_1,45.61666666666667), p(lat_2,47.05), p(lat_0,45), p(lon_0,-94.25), p(x_0,799999.9999999999), p(y_0,100000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102693, ps{p(proj_lcc), p(lat_1,43.78333333333333), p(lat_2,45.21666666666667), p(lat_0,43), p(lon_0,-94), p(x_0,799999.9999999999), p(y_0,100000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102694, ps{p(proj_tmerc), p(lat_0,29.5), p(lon_0,-88.83333333333333), p(k,0.99995), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102695, ps{p(proj_tmerc), p(lat_0,29.5), p(lon_0,-90.33333333333333), p(k,0.99995), p(x_0,700000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102696, ps{p(proj_tmerc), p(lat_0,35.83333333333334), p(lon_0,-90.5), p(k,0.9999333333333333), p(x_0,250000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102697, ps{p(proj_tmerc), p(lat_0,35.83333333333334), p(lon_0,-92.5), p(k,0.9999333333333333), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102698, ps{p(proj_tmerc), p(lat_0,36.16666666666666), p(lon_0,-94.5), p(k,0.9999411764705882), p(x_0,850000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102700, ps{p(proj_lcc), p(lat_1,45), p(lat_2,49), p(lat_0,44.25), p(lon_0,-109.5), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102704, ps{p(proj_lcc), p(lat_1,40), p(lat_2,43), p(lat_0,39.83333333333334), p(lon_0,-100), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102707, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-115.5833333333333), p(k,0.9999), p(x_0,200000), p(y_0,7999999.999999999), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102708, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-116.6666666666667), p(k,0.9999), p(x_0,500000.0000000002), p(y_0,6000000.000000001), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102709, ps{p(proj_tmerc), p(lat_0,34.75), p(lon_0,-118.5833333333333), p(k,0.9999), p(x_0,799999.9999999999), p(y_0,4000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102710, ps{p(proj_tmerc), p(lat_0,42.5), p(lon_0,-71.66666666666667), p(k,0.9999666666666667), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102711, ps{p(proj_tmerc), p(lat_0,38.83333333333334), p(lon_0,-74.5), p(k,0.9999), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102712, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-104.3333333333333), p(k,0.9999090909090909), p(x_0,165000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102713, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-106.25), p(k,0.9999), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102714, ps{p(proj_tmerc), p(lat_0,31), p(lon_0,-107.8333333333333), p(k,0.9999166666666667), p(x_0,829999.9999999999), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102715, ps{p(proj_tmerc), p(lat_0,38.83333333333334), p(lon_0,-74.5), p(k,0.9999), p(x_0,150000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102716, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-76.58333333333333), p(k,0.9999375), p(x_0,250000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102717, ps{p(proj_tmerc), p(lat_0,40), p(lon_0,-78.58333333333333), p(k,0.9999375), p(x_0,350000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102718, ps{p(proj_lcc), p(lat_1,40.66666666666666), p(lat_2,41.03333333333333), p(lat_0,40.16666666666666), p(lon_0,-74), p(x_0,300000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102719, ps{p(proj_lcc), p(lat_1,34.33333333333334), p(lat_2,36.16666666666666), p(lat_0,33.75), p(lon_0,-79), p(x_0,609601.2199999999), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102720, ps{p(proj_lcc), p(lat_1,47.43333333333333), p(lat_2,48.73333333333333), p(lat_0,47), p(lon_0,-100.5), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102721, ps{p(proj_lcc), p(lat_1,46.18333333333333), p(lat_2,47.48333333333333), p(lat_0,45.66666666666666), p(lon_0,-100.5), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102722, ps{p(proj_lcc), p(lat_1,40.43333333333333), p(lat_2,41.7), p(lat_0,39.66666666666666), p(lon_0,-82.5), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102723, ps{p(proj_lcc), p(lat_1,38.73333333333333), p(lat_2,40.03333333333333), p(lat_0,38), p(lon_0,-82.5), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102724, ps{p(proj_lcc), p(lat_1,35.56666666666667), p(lat_2,36.76666666666667), p(lat_0,35), p(lon_0,-98), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102725, ps{p(proj_lcc), p(lat_1,33.93333333333333), p(lat_2,35.23333333333333), p(lat_0,33.33333333333334), p(lon_0,-98), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102726, ps{p(proj_lcc), p(lat_1,44.33333333333334), p(lat_2,46), p(lat_0,43.66666666666666), p(lon_0,-120.5), p(x_0,2500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102727, ps{p(proj_lcc), p(lat_1,42.33333333333334), p(lat_2,44), p(lat_0,41.66666666666666), p(lon_0,-120.5), p(x_0,1500000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102728, ps{p(proj_lcc), p(lat_1,40.88333333333333), p(lat_2,41.95), p(lat_0,40.16666666666666), p(lon_0,-77.75), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102729, ps{p(proj_lcc), p(lat_1,39.93333333333333), p(lat_2,40.96666666666667), p(lat_0,39.33333333333334), p(lon_0,-77.75), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102730, ps{p(proj_tmerc), p(lat_0,41.08333333333334), p(lon_0,-71.5), p(k,0.99999375), p(x_0,100000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102733, ps{p(proj_lcc), p(lat_1,32.5), p(lat_2,34.83333333333334), p(lat_0,31.83333333333333), p(lon_0,-81), p(x_0,609600.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102734, ps{p(proj_lcc), p(lat_1,44.41666666666666), p(lat_2,45.68333333333333), p(lat_0,43.83333333333334), p(lon_0,-100), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102735, ps{p(proj_lcc), p(lat_1,42.83333333333334), p(lat_2,44.4), p(lat_0,42.33333333333334), p(lon_0,-100.3333333333333), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102736, ps{p(proj_lcc), p(lat_1,35.25), p(lat_2,36.41666666666666), p(lat_0,34.33333333333334), p(lon_0,-86), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102737, ps{p(proj_lcc), p(lat_1,34.65), p(lat_2,36.18333333333333), p(lat_0,34), p(lon_0,-101.5), p(x_0,200000), p(y_0,1000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102738, ps{p(proj_lcc), p(lat_1,32.13333333333333), p(lat_2,33.96666666666667), p(lat_0,31.66666666666667), p(lon_0,-98.5), p(x_0,600000.0000000001), p(y_0,2000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102739, ps{p(proj_lcc), p(lat_1,30.11666666666667), p(lat_2,31.88333333333333), p(lat_0,29.66666666666667), p(lon_0,-100.3333333333333), p(x_0,700000), p(y_0,3000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102740, ps{p(proj_lcc), p(lat_1,28.38333333333333), p(lat_2,30.28333333333334), p(lat_0,27.83333333333333), p(lon_0,-99), p(x_0,600000.0000000001), p(y_0,4000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102741, ps{p(proj_lcc), p(lat_1,26.16666666666667), p(lat_2,27.83333333333333), p(lat_0,25.66666666666667), p(lon_0,-98.5), p(x_0,300000), p(y_0,4999999.999999999), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102742, ps{p(proj_lcc), p(lat_1,40.71666666666667), p(lat_2,41.78333333333333), p(lat_0,40.33333333333334), p(lon_0,-111.5), p(x_0,500000.0000000002), p(y_0,1000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102743, ps{p(proj_lcc), p(lat_1,39.01666666666667), p(lat_2,40.65), p(lat_0,38.33333333333334), p(lon_0,-111.5), p(x_0,500000.0000000002), p(y_0,2000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102744, ps{p(proj_lcc), p(lat_1,37.21666666666667), p(lat_2,38.35), p(lat_0,36.66666666666666), p(lon_0,-111.5), p(x_0,500000.0000000002), p(y_0,3000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102745, ps{p(proj_tmerc), p(lat_0,42.5), p(lon_0,-72.5), p(k,0.9999642857142857), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102746, ps{p(proj_lcc), p(lat_1,38.03333333333333), p(lat_2,39.2), p(lat_0,37.66666666666666), p(lon_0,-78.5), p(x_0,3499999.999999999), p(y_0,2000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102747, ps{p(proj_lcc), p(lat_1,36.76666666666667), p(lat_2,37.96666666666667), p(lat_0,36.33333333333334), p(lon_0,-78.5), p(x_0,3499999.999999999), p(y_0,1000000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102748, ps{p(proj_lcc), p(lat_1,47.5), p(lat_2,48.73333333333333), p(lat_0,47), p(lon_0,-120.8333333333333), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102749, ps{p(proj_lcc), p(lat_1,45.83333333333334), p(lat_2,47.33333333333334), p(lat_0,45.33333333333334), p(lon_0,-120.5), p(x_0,500000.0000000002), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102750, ps{p(proj_lcc), p(lat_1,39), p(lat_2,40.25), p(lat_0,38.5), p(lon_0,-79.5), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102751, ps{p(proj_lcc), p(lat_1,37.48333333333333), p(lat_2,38.88333333333333), p(lat_0,37), p(lon_0,-81), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102752, ps{p(proj_lcc), p(lat_1,45.56666666666667), p(lat_2,46.76666666666667), p(lat_0,45.16666666666666), p(lon_0,-90), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102753, ps{p(proj_lcc), p(lat_1,44.25), p(lat_2,45.5), p(lat_0,43.83333333333334), p(lon_0,-90), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102754, ps{p(proj_lcc), p(lat_1,42.73333333333333), p(lat_2,44.06666666666667), p(lat_0,42), p(lon_0,-90), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102755, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-105.1666666666667), p(k,0.9999375), p(x_0,200000), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102756, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-107.3333333333333), p(k,0.9999375), p(x_0,399999.9999999999), p(y_0,100000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102757, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-108.75), p(k,0.9999375), p(x_0,600000.0000000001), p(y_0,0), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102758, ps{p(proj_tmerc), p(lat_0,40.5), p(lon_0,-110.0833333333333), p(k,0.9999375), p(x_0,799999.9999999999), p(y_0,100000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102761, ps{p(proj_lcc), p(lat_1,18.03333333333334), p(lat_2,18.43333333333333), p(lat_0,17.83333333333333), p(lon_0,-66.43333333333334), p(x_0,200000), p(y_0,200000), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(102766, ps{p(proj_poly), p(lat_0,13.47246635277778), p(lon_0,-144.7487507055556), p(x_0,49999.99999999999), p(y_0,49999.99999999999), p(ellps_grs80), p(srs::dpar::datum_nad83), p(to_meter,0.3048006096012192), p(no_defs)}),
            ce(103300, ps{p(proj_lcc), p(lat_1,49.8333339), p(lat_2,51.16666733333333), p(lat_0,90), p(lon_0,4.367486666666666), p(x_0,150000.01256), p(y_0,5400088.4378), p(ellps_intl), p(units_m), p(no_defs)}),
            ce(104000, ps{p(proj_longlat), p(ellps_clrk66), p(srs::dpar::datum_nad27), p(no_defs)}),
            ce(104101, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(104102, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(104103, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)}),
            ce(104104, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(104105, ps{p(proj_longlat), p(ellps_bessel), p(no_defs)}),
            ce(104106, ps{p(proj_longlat), p(ellps_intl), p(no_defs)}),
            ce(104107, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}),
            ce(104108, ps{p(proj_longlat), p(ellps_grs80), p(no_defs)}),
            ce(104261, ps{p(proj_longlat), p(a,6378249.2), p(b,6356514.999904194), p(no_defs)}),
            ce(104304, ps{p(proj_longlat), p(a,6378249.2), p(b,6356514.999904194), p(no_defs)}),
            ce(104305, ps{p(proj_longlat), p(ellps_clrk80), p(no_defs)})
        };

        const auto it = std::lower_bound(arr.begin(), arr.end(), code, code_element_less{});
        return it != arr.end() && it->code == code ? it->to_parameters() : srs::dpar::parameters<>();
    }

}
#endif // DOXYGEN_NO_DETAIL


}}} // namespace boost::geometry::projections

#endif
